package com.ejie.ab04b.util;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author GFI-NORTE
 *
 */
public class DaoUtils {

	private static DaoUtils instance;

	/**
	 * Gets the single instance of DaoUtils.
	 * 
	 *  DaoUtils
	 *
	 * @return single instance of DaoUtils
	 */
	public static DaoUtils getInstance() {
		if (DaoUtils.instance == null) {
			instance = new DaoUtils();
		}
		return DaoUtils.instance;
	}

	/**
	 * Gets the long nullable.
	 * 
	 *  rs            ResultSet
	 *  alias            String
	 *  Long
	 *
	 * @param rs the rs
	 * @param alias the alias
	 * @return the long nullable
	 * @throws SQLException             si se produce alún error al obtener el valor de la columna
	 *             alias
	 */
	public Long getLongNullable(ResultSet rs, String alias)
			throws SQLException {

		Long result = rs.getLong(alias);
		if (rs.wasNull()) {
			return null;
		}
		return result;
	}

	/**
	 * Gets the int nullable.
	 * 
	 *  rs            ResultSet
	 *  alias            String
	 *  Integer
	 *
	 * @param rs the rs
	 * @param alias the alias
	 * @return the int nullable
	 * @throws SQLException             si se produce alún error al obtener el valor de la columna
	 *             alias
	 */
	public Integer getIntNullable(ResultSet rs, String alias)
			throws SQLException {

		Integer result = rs.getInt(alias);
		if (rs.wasNull()) {
			return null;
		}
		return result;
	}

	/**
	 * Gets the string nullable.
	 * 
	 *  rs            ResultSet
	 *  alias            String
	 *  String
	 *
	 * @param rs the rs
	 * @param alias the alias
	 * @return the string nullable
	 * @throws SQLException             si se produce alún error al obtener el valor de la columna
	 *             alias
	 */
	public String getStringNullable(ResultSet rs, String alias)
			throws SQLException {

		String result = rs.getString(alias);
		if (rs.wasNull()) {
			return null;
		}
		return result;
	}
}
